VERSION 5.00
Begin VB.Form Clock 
   AutoRedraw      =   -1  'True
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   " 245 LED Clock"
   ClientHeight    =   2295
   ClientLeft      =   45
   ClientTop       =   315
   ClientWidth     =   3510
   BeginProperty Font 
      Name            =   "System"
      Size            =   9.75
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "Clock.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   153
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   234
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame Clock_Frame 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1650
      Left            =   120
      TabIndex        =   1
      Top             =   45
      Width           =   3255
      Begin VB.Frame Frame1 
         Height          =   725
         Left            =   120
         TabIndex        =   17
         Top             =   800
         Width           =   3015
         Begin VB.CommandButton Comm_Link 
            Caption         =   "&ON"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   350
            Left            =   2160
            TabIndex        =   20
            ToolTipText     =   "Click to set hours from now"
            Top             =   240
            Width           =   735
         End
         Begin VB.ComboBox Sel_Port 
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Left            =   1320
            TabIndex        =   18
            Top             =   240
            Width           =   705
         End
         Begin VB.Image Picker_Img 
            Height          =   480
            Index           =   1
            Left            =   120
            Picture         =   "Clock.frx":030A
            Top             =   165
            Width           =   480
         End
         Begin VB.Label Label1 
            Caption         =   "Comm:"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H8000000D&
            Height          =   255
            Index           =   2
            Left            =   720
            TabIndex        =   19
            Top             =   285
            Width           =   555
         End
      End
      Begin VB.Frame Set_Time_Frame 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   675
         Left            =   120
         TabIndex        =   4
         Top             =   120
         Width           =   3015
         Begin VB.CommandButton Set_System_Time 
            Caption         =   "&Set"
            Enabled         =   0   'False
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   350
            Left            =   2160
            TabIndex        =   15
            ToolTipText     =   "Click to program new time to PIC"
            Top             =   215
            Width           =   735
         End
         Begin VB.TextBox Sel_Time_Input 
            Alignment       =   1  'Right Justify
            BorderStyle     =   0  'None
            BeginProperty Font 
               Name            =   "Microsoft Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   210
            Index           =   3
            Left            =   1485
            TabIndex        =   5
            Text            =   "AM"
            Top             =   285
            Width           =   255
         End
         Begin VB.PictureBox Picture1 
            Appearance      =   0  'Flat
            BackColor       =   &H80000005&
            BorderStyle     =   0  'None
            ForeColor       =   &H80000008&
            Height          =   250
            Left            =   600
            ScaleHeight     =   255
            ScaleWidth      =   885
            TabIndex        =   6
            Top             =   240
            Width           =   885
            Begin VB.TextBox Sel_Time_Input 
               Alignment       =   1  'Right Justify
               BorderStyle     =   0  'None
               BeginProperty Font 
                  Name            =   "Microsoft Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   240
               Index           =   2
               Left            =   590
               MaxLength       =   2
               TabIndex        =   9
               Text            =   "00"
               Top             =   50
               Width           =   210
            End
            Begin VB.TextBox Sel_Time_Input 
               Alignment       =   1  'Right Justify
               BorderStyle     =   0  'None
               BeginProperty Font 
                  Name            =   "Microsoft Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   240
               Index           =   1
               Left            =   310
               MaxLength       =   2
               TabIndex        =   8
               Text            =   "00"
               Top             =   50
               Width           =   210
            End
            Begin VB.TextBox Sel_Time_Input 
               Alignment       =   1  'Right Justify
               BorderStyle     =   0  'None
               BeginProperty Font 
                  Name            =   "Microsoft Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   240
               Index           =   0
               Left            =   40
               MaxLength       =   2
               TabIndex        =   7
               Text            =   "00"
               Top             =   50
               Width           =   210
            End
            Begin VB.Label Label2 
               BackStyle       =   0  'Transparent
               Caption         =   ":"
               BeginProperty Font 
                  Name            =   "MS Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   255
               Index           =   0
               Left            =   540
               TabIndex        =   11
               Top             =   25
               Width           =   135
            End
            Begin VB.Label Label2 
               BackStyle       =   0  'Transparent
               Caption         =   ":"
               BeginProperty Font 
                  Name            =   "MS Sans Serif"
                  Size            =   8.25
                  Charset         =   0
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   255
               Index           =   1
               Left            =   240
               TabIndex        =   10
               Top             =   30
               Width           =   135
            End
         End
         Begin VB.TextBox Text1 
            BeginProperty Font 
               Name            =   "Microsoft Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   315
            Index           =   0
            Left            =   585
            TabIndex        =   13
            ToolTipText     =   "Selected Time"
            Top             =   225
            Width           =   1200
         End
         Begin VB.VScrollBar Adj_Sel_Time 
            Height          =   315
            Left            =   1800
            Max             =   -1
            Min             =   60
            TabIndex        =   12
            Top             =   225
            Value           =   60
            Width           =   255
         End
         Begin VB.Image Picker_Img 
            Height          =   480
            Index           =   0
            Left            =   50
            Picture         =   "Clock.frx":0614
            Top             =   120
            Width           =   480
         End
         Begin VB.Label Label1 
            Caption         =   "Set Time"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H8000000D&
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   14
            Top             =   0
            Width           =   675
         End
      End
   End
   Begin VB.PictureBox SegDigits 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   450
      Left            =   120
      Picture         =   "Clock.frx":091E
      ScaleHeight     =   28
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   199
      TabIndex        =   3
      Top             =   360
      Visible         =   0   'False
      Width           =   3010
   End
   Begin VB.PictureBox Col 
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H00000000&
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   360
      Picture         =   "Clock.frx":5465
      ScaleHeight     =   17
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   5
      TabIndex        =   2
      Top             =   960
      Visible         =   0   'False
      Width           =   75
   End
   Begin VB.CommandButton OK 
      Caption         =   "&Close"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   350
      Left            =   2040
      TabIndex        =   0
      ToolTipText     =   "Close & Accept "
      Top             =   1815
      Width           =   1365
   End
   Begin VB.Label Label3 
      Caption         =   "2007 Trent Jackson"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   16
      Top             =   1920
      Width           =   1695
   End
   Begin VB.Menu mPopupSys 
      Caption         =   ""
      Visible         =   0   'False
   End
End
Attribute VB_Name = "Clock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

   '-----------------------------------------------------------------------------
   '~~~~  PIC Driven LED Clock By Trent Jackson 2006 All rights reserved  ~~~~~~
   '-----------------------------------------------------------------------------
   '                                                                            '
   '          Version: eta 0.1                                                 '
   '  Project started: 17/05/07                                                 '
   '         Finished: 17/05/07                                                 '                                                  '
   ' Bugs & Enquiries: trentjackson888@bigpond.com.au                           '
   '                                                                            '
   '-----------------------------------------------------------------------------

Private Declare Sub InitCommonControls Lib "comctl32.dll" ()

'Locals
Dim Time_AM_PM       As Boolean
Dim Setting_New_Time As Boolean
Dim Set_Min          As String
Dim Set_Sec          As String
Dim Set_Hr           As String
Dim Set_Time_Str     As String
Dim strError         As String
Dim strData          As String
Dim intPortID        As Integer
Dim lngStatus        As Long
Dim lngSize          As Long

Private Sub Comm_Link_Click()
   
   Select Case Comm_Link.Caption
      Case "&ON"
           Comm_Link.Caption = "&OFF"
           Set_System_Time.Enabled = True
    
           '// Init Comms ...
           lngStatus = CommOpen(intPortID, "COM" & CStr(intPortID), "baud=2400 parity=N data=8 stop=1")
    
           If lngStatus <> 0 Then
              lngStatus = CommGetError(strError)
              MsgBox "COM Error: " & strError
              Comm_Link.Caption = "&ON"
              Set_System_Time.Enabled = False
           End If
      
      Case "&OFF"
           Comm_Link.Caption = "&ON"
           Set_System_Time.Enabled = False
           Call CommClose(intPortID)
   End Select
End Sub

Private Sub Form_Initialize()
   
   '// Win XP styles used
   InitCommonControls
End Sub

Private Sub Form_Load()

    '// Init clock with starting defaults ...
    Clock.Show
    intPortID = 2
    Set_Time_Str = "00:00:00"
    
    Dim i As Long
    For i = 1 To 9
        Sel_Port.AddItem (i)
    Next
    
    Sel_Port.ListIndex = 1
    
End Sub

Private Sub Sel_Port_Click()
   
   Call CommClose(intPortID)
   intPortID = Sel_Port.ListIndex + 1
End Sub

Private Sub Set_System_Time_Click()
   
   strData = "@" & Chr$(Mid$(Set_Time_Str, 1, 1)) & Chr$(Mid$(Set_Time_Str, 2, 1)) & Chr$(Mid$(Set_Time_Str, 4, 1)) & Chr$(Mid$(Set_Time_Str, 5, 1)) & Chr$(Mid$(Set_Time_Str, 7, 1)) & Chr$(Mid$(Set_Time_Str, 8, 1))

   lngSize = Len(strData)
   lngStatus = CommWrite(intPortID, strData)
   
   If lngStatus <> lngSize Then
   ' Handle error.
   End If
End Sub


Private Sub Sel_Time_Input_Click(Index As Integer)
   
   Dim i As Long

   '// Remove all selections in fields
   For i = 0 To 3
       Sel_Time_Input(i).SelLength = 0
   Next
   
   '// Sync current val with scroll bar
   If Val(Sel_Time_Input(Index).Text) < Adj_Sel_Time.Min Then
      Adj_Sel_Time.Value = Val(Sel_Time_Input(Index).Text)
   End If
      
   '// Highlight selection
   Sel_Time_Input(Index).SelStart = 0
   Sel_Time_Input(Index).SelLength = 2
   
   '// Enfore upper limit of adjustment w/ scroll bars
   Select Case Index
          Case 0
   '// Hrs
               Select Case Time_AM_PM
                      Case True
                           Adj_Sel_Time.Min = 13
                      Case False
                           Adj_Sel_Time.Min = 25
               End Select
   
   '// Secs & mins
          Case 1 To 2
               Adj_Sel_Time.Min = 60
   '//
          Case Else
               Adj_Sel_Time.Min = 2
   
   '// Sync w/ scroll bar
               Select Case Sel_Time_Input(3).Text
                      Case "AM"
                           Adj_Sel_Time.Value = 1
                      Case "PM"
                           Adj_Sel_Time.Value = 0
               End Select
   End Select
End Sub

Private Sub Adj_Sel_Time_Change()
   
   Dim i As Long
   Dim j As Long
   
   '// Find the active text field (hrs, mins sec or am / pm adj)
   For i = 0 To 3
       If Sel_Time_Input(i).SelText <> vbNullString Then 'Field selected?
          If i < 3 Then                                  'Num adj, sec, hr, mins
             j = Adj_Sel_Time.Value                      'Buff scroll bar val
          
   '// Hrs must be =>1 with 12hr operataion
             If Time_AM_PM And i = 0 And j < 1 Then j = 1
   
   '// Replace adjusted val back into text field
             Sel_Time_Input(i).Text = String(2 - Len(Trim(Str(j))), "0") & Trim(Str(j))
          '//
          Else                                           'AM / PM adj
          '//
             If Adj_Sel_Time.Value = 0 Then
                Sel_Time_Input(3).Text = "PM"
             Else
                Sel_Time_Input(3).Text = "AM"
             End If
          End If
          
   '// Return focus to text field & highlight all text
          Sel_Time_Input(i).SetFocus
          Sel_Time_Input(i).SelStart = 0
          Sel_Time_Input(i).SelLength = 2
       End If
   Next
   
   '// If scroll bar reaches upper limit then dec by 1 maintain focus
   If Adj_Sel_Time.Value = Adj_Sel_Time.Min Then
      Adj_Sel_Time.Value = Adj_Sel_Time.Value - 1
   
   '// Same story but w/ lower limit of the bar, hold at 0
   ElseIf Adj_Sel_Time.Value = Adj_Sel_Time.Max Then
      Adj_Sel_Time.Value = 0
   End If
   
   '// Refresh adj time
   Set_Hr = Sel_Time_Input(0).Text
   Set_Min = Sel_Time_Input(1).Text
   Set_Sec = Sel_Time_Input(2).Text
   
   '// Bulid full time return string in 24hr format regardless
   Set_Time_Str = Set_Hr & ":" & Set_Min & ":" & Set_Sec & Space(0) & Sel_Time_Input(3).Text
End Sub

Private Sub Sel_Time_Input_Change(Index As Integer)

   '// User may key in values too
   If Setting_New_Time Then Exit Sub
   
   '// Overflow check
   If Val(Sel_Time_Input(0)) > 12 And Time_AM_PM Then
      MsgBox "Maximum allowed hours is 12", vbOKOnly, "Can't Set Hours"
      Sel_Time_Input(0).Text = "12"
      Exit Sub
   
   '// Max hrs
   ElseIf Val(Sel_Time_Input(0)) > 23 Then
      MsgBox "Maximum allowed hours is 23", vbOKOnly, "Can't Set Hours"
      Sel_Time_Input(0).Text = "23"
      Exit Sub
   End If
   
   '// Mins
   If Val(Sel_Time_Input(1)) > 59 Then
      MsgBox "Maximum allowed minutes is 59", vbOKOnly, "Can't Set Minutes"
      Sel_Time_Input(1).Text = "59"
      Exit Sub
   End If
   
   '// Secs
   If Val(Sel_Time_Input(2)) > 59 Then
      MsgBox "Maximum allowed seconds is 59", vbOKOnly, "Can't Set seconds"
      Sel_Time_Input(2).Text = "59"
      Exit Sub
   End If
      
   '// Apply new val
   Adj_Sel_Time.Value = Val(Sel_Time_Input(Index).Text)
End Sub

Private Sub Sel_Time_Input_GotFocus(Index As Integer)
   
   '// Highlight selection when user tabs to field
   If Sel_Time_Input(Index).SelText = vbNullString Then
      Call Sel_Time_Input_Click(Index)
   End If
End Sub

Private Sub Sel_Time_Input_KeyPress(Index As Integer, KeyAscii As Integer)
   
   '// Ensure numerical values only
   If Not ((KeyAscii >= Asc("0") And KeyAscii <= Asc("9"))) Then
      If KeyAscii <> 8 Then                            'Allow backspace
         KeyAscii = 0                                  'Force to zero
      End If                                           '(Field  will not update)
   End If
End Sub

Private Sub OK_Click()
   
   Unload Me
End Sub

Private Sub Form_Unload(Cancel As Integer)
   
   Set Clock = Nothing
   Call CommClose(intPortID)
End Sub

Private Sub Time_Format_Click(Index As Integer)
   
   Time_AM_PM = Time_Format(1).Value
End Sub
